// src/shared/browser.js
var browserAPI = (() => {
  if (typeof browser !== "undefined" && browser.runtime && browser.runtime.getBrowserInfo) {
    return browser;
  } else if (typeof chrome !== "undefined" && chrome.runtime) {
    return chrome;
  } else if (typeof browser !== "undefined" && browser.runtime) {
    return browser;
  }
  return {
    runtime: void 0,
    storage: void 0,
    tabs: void 0,
    windows: void 0,
    action: void 0,
    browserAction: void 0
  };
})();
var runtime = {
  get id() {
    if (!browserAPI.runtime) {
      return void 0;
    }
    return browserAPI.runtime.id;
  },
  getURL: (path) => {
    if (!browserAPI.runtime) {
      throw new Error("Runtime API is not available in this context");
    }
    return browserAPI.runtime.getURL(path);
  },
  sendMessage: (message, responseCallback) => {
    if (!browserAPI.runtime) {
      throw new Error("Runtime API is not available in this context");
    }
    return browserAPI.runtime.sendMessage(message, responseCallback);
  },
  get onMessage() {
    if (!browserAPI.runtime) {
      return void 0;
    }
    return browserAPI.runtime.onMessage;
  },
  get onStartup() {
    if (!browserAPI.runtime) {
      return void 0;
    }
    return browserAPI.runtime.onStartup;
  },
  get onInstalled() {
    if (!browserAPI.runtime) {
      return void 0;
    }
    return browserAPI.runtime.onInstalled;
  },
  connect: (connectInfo) => {
    if (!browserAPI.runtime) {
      throw new Error("Runtime API is not available in this context");
    }
    return browserAPI.runtime.connect(connectInfo);
  },
  getPlatformInfo: (callback) => {
    if (!browserAPI.runtime) {
      callback({ os: "unknown", arch: "unknown" });
      return;
    }
    if (browserAPI.runtime.getPlatformInfo) {
      return browserAPI.runtime.getPlatformInfo(callback);
    } else {
      callback({ os: "unknown", arch: "unknown" });
    }
  },
  getManifest: () => {
    if (!browserAPI.runtime) {
      throw new Error("Runtime API is not available in this context");
    }
    return browserAPI.runtime.getManifest();
  },
  get lastError() {
    if (!browserAPI.runtime) {
      return void 0;
    }
    return browserAPI.runtime.lastError;
  },
  openOptionsPage: () => {
    if (!browserAPI.runtime) {
      throw new Error("Runtime API is not available in this context");
    }
    if (browserAPI.runtime.openOptionsPage) {
      browserAPI.runtime.openOptionsPage();
    } else {
      if (browserAPI.tabs) {
        browserAPI.tabs.create({ url: browserAPI.runtime.getURL("options/index.html") });
      } else {
        throw new Error("Tabs API is not available in this context");
      }
    }
  }
};
var tabs = {
  query: (queryInfo, callback) => {
    if (!browserAPI.tabs) {
      throw new Error("Tabs API is not available in this context");
    }
    return browserAPI.tabs.query(queryInfo, callback);
  },
  get: (tabId, callback) => {
    if (!browserAPI.tabs) {
      throw new Error("Tabs API is not available in this context");
    }
    return browserAPI.tabs.get(tabId, callback);
  },
  create: (createProperties, callback) => {
    if (!browserAPI.tabs) {
      throw new Error("Tabs API is not available in this context");
    }
    return browserAPI.tabs.create(createProperties, callback);
  },
  sendMessage: (tabId, message, responseCallback) => {
    if (!browserAPI.tabs) {
      throw new Error("Tabs API is not available in this context");
    }
    return browserAPI.tabs.sendMessage(tabId, message, responseCallback);
  },
  get onUpdated() {
    if (!browserAPI.tabs) {
      return void 0;
    }
    return browserAPI.tabs.onUpdated;
  }
};

// src/shared/runtime.js
function getRuntimeURL(path) {
  try {
    if (!runtime?.getURL) {
      throw new Error("Extension runtime is not available");
    }
    return runtime.getURL(path);
  } catch (error) {
    console.error("Failed to get runtime URL:", error);
    return path;
  }
}
function isRuntimeAvailable() {
  try {
    if (!runtime) {
      return false;
    }
    if (!runtime.id) {
      return false;
    }
    if (typeof runtime.sendMessage !== "function") {
      return false;
    }
    return true;
  } catch (error) {
    return false;
  }
}

// src/about/index.js
function setLogo() {
  if (!isRuntimeAvailable()) return;
  const el = document.getElementById("aboutLogo");
  if (el) el.src = getRuntimeURL("public/xrpl universe.png");
}
function setVersion() {
  try {
    const version = runtime?.getManifest?.().version;
    if (version) {
      const span = document.getElementById("extVersion");
      if (span) span.textContent = version;
    }
  } catch {
  }
}
document.getElementById("openOptions")?.addEventListener("click", () => {
  try {
    runtime.openOptionsPage();
  } catch {
  }
});
document.getElementById("backToPopup")?.addEventListener("click", () => {
  if (!isRuntimeAvailable()) return;
  const url = getRuntimeURL("popup/index.html");
  tabs.create({ url });
});
setLogo();
setVersion();
